-- Weather Underground to Apple //
-- 2011 Kevin Dady
--  
-- functions passed on to external programs via command line

cmd = {}


-- sleep 
cmd.sleep = function(time)
	os.execute("sleep ".. time)
end

-- convert JPG from website to pallatized XPM format ascii file with ImageMagick
cmd.imageMGK = function(command)
	os.execute("convert"..command)
end

-- send the radar image data one line at a time via serial 
cmd.sjinn = function(string)
	-- serial i/o program for simple devices http://sjinn.sourceforge.net
	os.execute("sjinn -d"..cmd.serialPort.." -b600 -s"..string.."\r")
	cmd.sleep((#string / 140) + 0.5)
end

-- download webpage and radar image
cmd.wget = function(string, filename)
	os.execute("wget \""..string.."\" -O temp/"..filename)
end 

-- easy html tag striping action 
cmd.lynx = function(page)
	os.execute("lynx -dump \""..page.."\" > temp/text.txt")
end


